/*
    Copyright (C) 2005 - 2006 Manuel Lausch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Manuel Lausch
    Rudolfstr. 9
    75177 Pforzheim
    GERMANY
    software@manuellausch.de
*/

#include <iostream>
#include <stdlib.h>
#include <SDL.h>
#include <SDL_gfxPrimitives.h>
#include <SDL_thread.h>
#include <SDL_ttf.h>
#include <SDL_image.h>
#include <SDL_mixer.h>
#include "snake.h"

using std::cerr;
using std::endl;
using std::cout;

SDL_Surface * initMyGame();
void help();


int main(int argc, char** argv)
{
	const int MAXPLAYER = 2; // max amount of players, it depends on the defined colors and keys
	int playercolor[] = {0x0000ffff , 0xffff00ff, 0xff0000ff, 0x808080ff }; // here are colors for 4 different players defined
	const int speed = 50; // umgekehrt proporzional -> je hher der wert, um so langsamer die geschwindigkeit
	int ende, taste = 0, num_player = 1;
	int LevelNumberVonArgv = 0; // Von wem kommt nur diese Variablenbezeichnung? Sie stellt jedenfalls dar,
	// an welchem index in argv der dateiname des levels steht.

	for(int i = 1; i < argc; i++)
	{
		if(argv[i][0] == '-')
		{
			switch(argv[i][1])
			{
				case 'P':
					num_player = atoi(argv[i + 1]); // sowas fhrt gerne zu seg-faults, wenn keine zahl eingegeben wurde
					break;

				case 'L':
					LevelNumberVonArgv = i + 1; // Und das ist hnlich schlimm
					break;

				case 'h':
				case '?':
					help();
					return 0;
					break;
			}
		}
	}

	if(MAXPLAYER < num_player)
	{
		cout << "Es koennen maximal " << MAXPLAYER << " Spieler mitspielen." << endl;
		return 0;
	}
	if(num_player == 0)
	{
		cout << "Wie bitte soll man ohne Spieler spielen???" << endl;
		return 0;
	}
	if(num_player < 0)
	{
		cout << "Wenn du mir verrtst, wie ein negativer Spieler ausschaut, kann ich den gerne einbauen..." << endl;
		return 0;
	}

	SDL_Surface *pDisplay, *pBackup = 0, *pPause = 0;
	SDL_Rect drec;
	SDL_Event event;
	snake *player[num_player];
	SDL_Thread *thread[num_player];	// Ja, jeder spieler ein eigenes thread - noch :-)
	int pause = 0;
	SDL_mutex *mutex;

	// Variablen fr Soundausgabe
	Mix_Music *music;
	Mix_Chunk *punkt, *crash;
	
	// Audioausgabe starten
	Mix_OpenAudio(44100, AUDIO_S16, 2, 1024);
	punkt = Mix_LoadWAV("./click.wav");
	crash = Mix_LoadWAV("./crash.wav");
	music = Mix_LoadMUS("./ein1.mod");

	Mix_AllocateChannels(2);
	
	// Lautstrken setzen
	Mix_VolumeChunk(crash, MIX_MAX_VOLUME);
	Mix_VolumeChunk(punkt, MIX_MAX_VOLUME/3*2);
	
	// Backgroundmusic starten
	Mix_PlayMusic(music, -1); // Endlosschleife fr die Musik: Problem bei neustart der musik wird die lautstrke wieder auf max gesetzt
	Mix_VolumeMusic(MIX_MAX_VOLUME/3); // Lautstrke kann erst nach Mix_PlayMusic gendert werden

	
	// init playground
	pDisplay = initMyGame();
	playground *pPlayground;
	if(LevelNumberVonArgv != 0) // ist ein Levelname definiert ?
		pPlayground = new playground(pDisplay, argv[LevelNumberVonArgv]); // Ja
	else
		pPlayground = new playground(pDisplay); // Nein

	mutex = SDL_CreateMutex();

	pPause = IMG_Load("./pause.png");

	// also wenn ich schon so ne definition wie
	// SDL_Surface *SDL_CreateRGBSurface (Uint32 flags, int breite, int hhe, int bpp, Uint32 Rmaske, Uint32 Gmaske, int32 Bmaske, Uint32 Amask)
	// sehe, dann doch lieber so ;)
	pBackup = IMG_Load("./pause.png");

	drec.w = pPause->w;
	drec.h = pPause->h;
	drec.x = (PLAYGROUND_WIDTH*QUADSIZE - pPause->w) / 2;
	drec.y = (PLAYGROUND_HEIGHT*QUADSIZE - pPause->h) / 2;

	// create players
	for(int i = 0; i < num_player; i++)
	{
		player[i] = new snake(pDisplay, pPlayground, mutex);
		player[i]->set_speed(speed);
		player[i]->set_color(playercolor[i]);
		thread[i] = SDL_CreateThread(snake::start, player[i]);
	}

	ende = 0;
	SDL_EventState(SDL_KEYUP, SDL_IGNORE); // Wir wollen nur Tastendrcke verarbeiten, loslassen der taste interessiert nicht.
	do // Event-loop
	{
		 SDL_WaitEvent(&event);
		 switch(event.type)
		{
			case SDL_KEYDOWN:
				taste = event.key.keysym.sym;
				break;
			case SDL_QUIT:
				ende += 1;
				break;

			case SDL_USEREVENT:
				if(event.user.code == 'p')
					Mix_PlayChannel(-1, punkt, 0);
				if(event.user.code == 'c')
					Mix_PlayChannel(-1, crash, 0);
				break;
			default:
				taste = 0;
		}

		// Pause Funktion
		// wird durch blockieren des Mutex geregelt.
		if (taste == ' ')
		{
			switch(pause)
			{
			case 0:
				pause = 1;
				SDL_mutexP(mutex);
				SDL_BlitSurface(pDisplay, &drec, pBackup, NULL);
				SDL_BlitSurface(pPause, NULL, pDisplay, &drec);
				SDL_Flip(pDisplay);
				break;
			case 1:
				pause = 0;
				SDL_BlitSurface(pBackup, NULL, pDisplay, &drec);
				SDL_Flip(pDisplay);
				SDL_mutexV(mutex);
				break;
			}
		}
		// ! Hier sollten dann aber auch alle weiter bettigten Tasten ignoeriert werden.
		if (pause == 1) continue; 	// was hiermit quick & dirty durch abbruch weiterer
								// verarbeitung im pause mode geschehen ist :)

		switch(taste)
		{
			case 273: player[0]->ways.push(up); break;
			case 274: player[0]->ways.push(down); break;
			case 275: player[0]->ways.push(right); break;
			case 276: player[0]->ways.push(left); break;
		}

		if(num_player > 1)
		{
			switch(taste)
			{
				case 'w': player[1]->ways.push(up); break;
				case 's': player[1]->ways.push(down); break;
				case 'd': player[1]->ways.push(right); break;
				case 'a': player[1]->ways.push(left); break;
				// Bser Hack fr 4 player mode - provoziert segfaults.
				//  OK, OK, bin ja nur zufaul das brauchbar zu implementieren
				// case 'i': player[2]->ways.push(up); break;
				// case 'k': player[2]->ways.push(down); break;
				// case 'l': player[2]->ways.push(right); break;
				// case 'j': player[2]->ways.push(left); break;

				// case 's': player[3]->ways.push(up); break;
				// case 'x': player[3]->ways.push(down); break;
				// case 'c': player[3]->ways.push(right); break;
				// case 'y': player[3]->ways.push(left); break;
			}
		}

	}
	while(0 == ende);

	// cleaning the memory and quit the game
	for(int i = 0; i < num_player; i++)
	{
		SDL_KillThread(thread[i]);
		delete player[i];
	}

	return 0;
}

void help()
{
	cout << "snake -L [Level (Dateiname)] -P [Anzahl Spieler]\n\n" << endl;
	cout << "Befehl:\t\tFunktion:\n\n";
	cout << "-L\t\tLevel (Dateiname)" << endl;
	cout << "-P\t\tSpieleranzahl" << endl;
	cout << "-h\t\tDiese Hilfe" << endl;
	cout << "-?\t\tSiehe -H" << endl;
}

SDL_Surface * initMyGame()
{
	SDL_Surface * pDisplay;

	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0)
	{
	cerr << "SDL Konnte nicht initialisiert werden:  " << SDL_GetError() << endl;
		exit(-1);
	}

	if(TTF_Init() < 0)
	{
	cerr << "TTF konnte nicht initialisiert werden:  " << TTF_GetError() << endl;
		exit(-1);
	}
	
	atexit(SDL_Quit);
	atexit(TTF_Quit);

	if (!(pDisplay = SDL_SetVideoMode(QUADSIZE*PLAYGROUND_WIDTH, QUADSIZE*PLAYGROUND_HEIGHT + 50, 16, SDL_HWSURFACE)))
	{
	cerr << "Video Mode konnte nicht initialisiert werden:  " << SDL_GetError() << endl;
		exit(-1);
	}

	hlineColor(pDisplay, 0, QUADSIZE*PLAYGROUND_WIDTH, QUADSIZE*PLAYGROUND_HEIGHT, 0xffffffff);
	SDL_Flip(pDisplay);

	SDL_WM_SetCaption("Snake 0.4", NULL);
	SDL_WM_SetIcon(SDL_LoadBMP("./icon.bmp"), NULL);
	SDL_ShowCursor(SDL_DISABLE);
	return pDisplay;
}
