/*
    Copyright (C) 2005 - 2006 Manuel Lausch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Manuel Lausch
    Rudolfstr. 9
    75177 Pforzheim
    GERMANY
    software@manuellausch.de
*/

#include <iostream>
#include <fstream>
#include <queue>
#include <SDL.h>
#include <SDL_gfxPrimitives.h>
#include <SDL_thread.h>
#include <SDL_ttf.h>
#include "snake.h"

// using std::queue;

unsigned int snake::food = 0;

snake::snake(SDL_Surface *pD, playground *pP, SDL_mutex *pMut)
{
	// Font fr Textausgabe laden
	// Diese Zeilen sollten Hier aber raus, und in eine extra textausgabe klasse oder so
	// eingebaut werden.
	pFont = TTF_OpenFont("./arial.ttf", 20);
	if (pFont == NULL)
	{
		std::cerr << "Font konnte nicht geffnet werden\n" ;
	}

	pDisplay = pD;
	pPlayground = pP;
	this->pMut = pMut;

	int tt = rand() % PLAYGROUND_WIDTH; // Zufllige spalte fr schlangenanfang

	// initial position of snake
	// ahm, die farbe ist da irgendwie so hart reinkodiert... naja, was solls
	color = 0x0000ffff;
	speed = 50;
	
	pPlayground->set_field(tt, 1, f_snake, color);
	pPlayground->set_field(tt, 2, f_snake, color);

	punkte = 0;

	x = tt;
	y = 2;
	default_direction = down;

	koordinate temp;
	temp.x = tt;
	temp.y = 1;
	snake_queue.push(temp);
	temp.y = 2;
	snake_queue.push(temp);

	if(food == 0)
		generate_food();

	my_number = ++food; //puhhh, ab der stelle hat food nix mehr mit dem futter zu tun,
	//sondern mit der position der textausgabe der punkte.....

}

snake::~snake()
{
	/* Nette Spielerei, aber dafr fehlt irgendwie ne passendere ifrastrucktur ;)
	for (int i=0; i < punkte+2; i++)
	{
		SDL_mutexP(pMut);
		pPlayground->del_field(snake_queue.front().x, snake_queue.front().y);
		snake_queue.pop();
		SDL_mutexV(pMut);
		SDL_Delay(1000);
	}
	*/
}

int snake::step()
{
	SDL_mutexP(pMut);
	direction way = ways.get();
	form design = block;

	if (default_direction == right	&& way == down)	design = edge1;
	if (default_direction == up	&& way == left)	design = edge1;

	if (default_direction == right	&& way == up)	design = edge2;
	if (default_direction == down	&& way == left)	design = edge2;

	if (default_direction == down	&& way == right)	design = edge3;
	if (default_direction == left	&& way == up)	design = edge3;

	if (default_direction == up	&& way == right)	design = edge4;
	if (default_direction == left	&& way == down)	design = edge4;

	if ((default_direction == right || default_direction == left) && way == old) design = partX;
	if ((default_direction == up || default_direction == down) && way == old) design = partY;

	pPlayground->set_field(x, y, f_snake, get_color(), design);

	if ((way == down && default_direction != up) || (way == right && default_direction != left) || (way == up && default_direction != down) || (way == left && default_direction != right))
		default_direction = way;

	switch (default_direction)
	{
	case up:
		if (0 == y) y = PLAYGROUND_HEIGHT;
		y--;
		design = begin1;
		break;

	case right:
		x++;
		if (x == PLAYGROUND_WIDTH) x = 0;
		design = begin2;
		break;

	case down:
		y++;
		if (y == PLAYGROUND_HEIGHT) y = 0;
		design = begin3;
		break;

	case left:
		if (0 == x) x = PLAYGROUND_WIDTH;
		x--;
		design = begin4;
		break;
	}


	if(pPlayground->get_field(x, y) == f_food)
	{
		generate_food();
		SDL_Event event;
		SDL_UserEvent uevent;
		uevent.type = SDL_USEREVENT;
		uevent.code = 'p';
		uevent.data1 = uevent.data2 = NULL; // Um warnungen im GCC4 zu vermeiden. Diese Strukturvariablen werden derzeit nmlich noch nicht bentigt.
		event.user = uevent;
		SDL_PushEvent(&event);
			
		punkte++;
		{
			SDL_Rect drect;
			SDL_Surface *font_src = 0;
			char titel[256];
			sprintf(titel, "Punkte: %d", punkte);
			SDL_Color color = {255,255,255};
			//font_src = TTF_RenderText_Solid(pFont, titel, color);  // hat irgendwie ein bug
			 font_src = TTF_RenderText_Blended(pFont, titel, color);  // drum den workaround
			if (font_src == 0)
			{
				std::cerr << "Fehler beim Textrendering ---> Text wird nicht ausgegeben. -- " << SDL_GetError() << TTF_GetError() << "\n";
				// exit(-1); // muss angepasst werden wegen den threads..
			}
			else
			{
				drect.x = (my_number - 1) * 120 + 20;
				drect.y = PLAYGROUND_HEIGHT*QUADSIZE + 10;
				drect.w = font_src->w;
				drect.h = font_src->h;
				boxColor(pDisplay, drect.x, drect.y, drect.x+drect.w, drect.y+drect.h, 0x000000ff);
				SDL_BlitSurface(font_src, NULL, pDisplay, &drect);
				SDL_Flip(pDisplay);
			}
		}
	}
	else
	{
		pPlayground->del_field(snake_queue.front().x, snake_queue.front().y);
		snake_queue.pop();
	}

	koordinate temp;
	temp.x = x;
	temp.y = y;
	snake_queue.push(temp);


	if(pPlayground->get_field(x, y) == f_wall || pPlayground->get_field(x, y) == f_snake)
	{
		SDL_mutexV(pMut);
		
		SDL_Event event;
		SDL_UserEvent uevent;
		uevent.type = SDL_USEREVENT;
		uevent.code = 'c';
		uevent.data1 = uevent.data2 = NULL; // Um warnungen in GCC4 zu vermeiden
		event.user = uevent;
		SDL_PushEvent(&event);

		return 1;
	}
	else
	{
		pPlayground->set_field(x, y, f_snake, get_color(), design);
		SDL_mutexV(pMut);
		return 0;
	}
}

void snake::generate_food()
{
	srand(time(0));
	unsigned short int px, py;

	do
	{
		px = (unsigned short int) (rand() % PLAYGROUND_WIDTH);
		py = (unsigned short int) (rand() % PLAYGROUND_HEIGHT);
	} while (pPlayground->get_field(px, py) != f_empty);

	pPlayground->set_field(px, py, f_food, 0x00ff00ff);
}

int snake::start(void* arg)
{
	snake * player = (snake*) arg;
	while(player->step() == 0)
	{
		SDL_Delay(player->get_speed());
	}
	return 0;
}

unsigned short int snake::get_speed()
{
	return speed;
}

void snake::set_speed(unsigned short int arg)
{
	speed = arg;
}

Uint32 snake::get_color()
{
	return color;
}

void snake::set_color(Uint32 arg)
{
	color = arg;
}


queue_key::queue_key()
{
	begin = end = 0;
}

queue_key::~queue_key()
{
}

direction queue_key::get()
{
	if(begin == end)
		return old;

	direction way = ways[end];

	end++;
	if(end == 20) end = 0;

	return way;
}

void queue_key::push(direction way)
{
	unsigned short int temp;
	if(begin == 0)
		temp = 19;
	else
		temp = begin - 1;

	if(ways[temp] != way) // filtert eine richtungsnderung in die gleiche richtung wie zuvor raus.
	{
		ways[begin] = way;

		begin++;
		if(begin == 20) begin = 0;
	}
}


playground::playground(SDL_Surface* pDisp)
{
	pDisplay = pDisp;
	for(int x = 0; x < PLAYGROUND_WIDTH; x++)
		for(int y = 0; y < PLAYGROUND_HEIGHT; y++)
			del_field(x, y);
}

playground::playground(SDL_Surface* pDisp, char* wall_name)
{
	// DIese Funktion ist hoch gefhrlich, da berhaupt keine kontrolle, was fr
	// Daten eingelesen werden.
	pDisplay = pDisp;
	std::ifstream fin(wall_name);
	char ch;

	// Und dann auch noch hard kodierte werde, die ich wo anderster als prprozessor
	// werte definiert habe.....
	for(int y = 0; y < 50; y++)
		for(int x = 0; x < 50; x++)
		{
			fin.get(ch);

			if(ch == f_empty)
				del_field(x, y);
			if(ch == f_wall)
				set_field(x, y, f_wall, 0xffffffff, solid);

		}

	fin.close();
}

playground::~playground()
{
}

void playground::set_field(short int x, short int y, field type, Uint32 color, form design)
{
	SDL_Rect drect;
	// quadrat erst schwrzen bevor neu drauf gemalt wird, kommt sonst zu grafikfehlern bei den ecken
	// es bleibt zu diskutieren, ob das dann nicht nur an seliben gemacht werden sollte.
	boxColor(pDisplay, x * QUADSIZE, y * QUADSIZE, x * QUADSIZE + QUADSIZE - 1, y * QUADSIZE + QUADSIZE - 1, 0x000000ff);

	grid[x][y] = type;
	if(type == f_food)	design=circle;	// food hat geflligst rund zu sein ;)

	switch(design)
	{
	case circle:
		filledCircleColor(pDisplay, x * QUADSIZE + QUADSIZE / 2 - 1, y * QUADSIZE + QUADSIZE / 2 - 1, (QUADSIZE - 1) / 2, color);
		break;

	case block:
		boxColor(pDisplay, x * QUADSIZE, y * QUADSIZE, x * QUADSIZE + QUADSIZE - 2, y * QUADSIZE + QUADSIZE - 2, color);
		break;

	case solid:
		boxColor(pDisplay, x * QUADSIZE, y * QUADSIZE, x * QUADSIZE + QUADSIZE - 1, y * QUADSIZE + QUADSIZE -1, color);
		break;

	case partX:
		boxColor(pDisplay, x * QUADSIZE, y * QUADSIZE, x * QUADSIZE + QUADSIZE - 1, y * QUADSIZE + QUADSIZE -2, color);
		break;

	case partY:
		boxColor(pDisplay, x * QUADSIZE, y * QUADSIZE, x * QUADSIZE + QUADSIZE - 2, y * QUADSIZE + QUADSIZE -1, color);
		break;

	case edge1:
		boxColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE + QUADSIZE -1), color);
		filledTrigonColor(pDisplay, (x * QUADSIZE + QUADSIZE / 4), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE + QUADSIZE *3 / 4 - 1 ), 0x000000ff);
		// hier gibts scheints noch probleme mit nachkommastellen bei der division
		break;

	case edge2:
		boxColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE + QUADSIZE -2), color);
		filledTrigonColor(pDisplay, (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE + QUADSIZE / 4), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE + QUADSIZE - 2), (x * QUADSIZE + QUADSIZE / 4), (y * QUADSIZE + QUADSIZE - 2), 0x000000ff);
		break;

	case edge3:
		boxColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE -1), (y * QUADSIZE + QUADSIZE -2), color);
		filledTrigonColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE + QUADSIZE / 4), (x * QUADSIZE + QUADSIZE * 3 / 4 -1), (y * QUADSIZE + QUADSIZE - 2), (x * QUADSIZE), (y * QUADSIZE + QUADSIZE - 2), 0x000000ff);
		break;

	case edge4:
		boxColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 1), (y * QUADSIZE + QUADSIZE - 1), color);
		filledTrigonColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE * 3 / 4 - 1), (y * QUADSIZE), (x * QUADSIZE), (y * QUADSIZE + QUADSIZE * 3 / 4 - 1), 0x000000ff);
		pixelColor(pDisplay, (x * QUADSIZE + QUADSIZE - 1), (y * QUADSIZE + QUADSIZE - 1), 0x000000ff);
		break;

	case begin1:
		filledTrigonColor(pDisplay, (x * QUADSIZE + QUADSIZE / 2 - 1), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE + QUADSIZE - 1), (x * QUADSIZE), (y * QUADSIZE + QUADSIZE - 1), color);
		break;

	case begin2:
		filledTrigonColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE  + QUADSIZE  / 2 - 1), (x * QUADSIZE), (y * QUADSIZE + QUADSIZE - 2), color);
		break;

	case begin3:
		filledTrigonColor(pDisplay, (x * QUADSIZE), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 2), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE / 2 - 1), (y * QUADSIZE + QUADSIZE - 2), color);
		break;

	case begin4:
		filledTrigonColor(pDisplay, (x * QUADSIZE + 1), (y * QUADSIZE + QUADSIZE / 2 - 1), (x * QUADSIZE + QUADSIZE - 1), (y * QUADSIZE), (x * QUADSIZE + QUADSIZE - 1), (y * QUADSIZE + QUADSIZE - 2), color);
		break;

	default: ;
		// zum unterdrcken einiger warnungen.
	}

	drect.x = x * QUADSIZE;
	drect.y = y * QUADSIZE;
	drect.w = drect.h = QUADSIZE;
	SDL_UpdateRects(pDisplay, 1, &drect);
}

void playground::del_field(short int x, short int y)
{
	playground::set_field(x,y, f_empty, 0x000000ff, solid);
}

field playground::get_field(short int x, short int y)
{
//	std::cout << grid[x][y] << "  " << x << "  " << y << std::endl;
	return grid[x][y];
}
