/*
    Copyright (C) 2005 - 2006 Manuel Lausch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Manuel Lausch
    Rudolfstr. 9
    75177 Pfohrzheim
    GERMANY
    software@manuellausch.de
*/
#ifndef SNAKE_H
#define SNAKE_H

#define PLAYGROUND_WIDTH	50
#define PLAYGROUND_HEIGHT	50
#define PLAYGROUND_SIZE		(PLAYGROUND_WIDTH * PLAYGROUND_HEIGHT)
#define QUADSIZE		10

#include<queue>
#include<SDL_ttf.h>

enum field {f_empty, f_wall, f_snake, f_food} ;
enum direction {old, up, down, right, left};
enum form {solid, block, edge1, edge2, edge3, edge4, partX, partY, begin1, begin2, begin3, begin4, end1, end2, end3, end4, circle};

class koordinate
{
public:
	unsigned short int x;
	unsigned short int y;
};


class playground
{
public:
	playground(SDL_Surface*);
	playground(SDL_Surface*, char*);
	~playground();

	void set_field(short int, short int, field, Uint32, form=block);
	void del_field(short int, short int);
inline	field get_field(short int, short int);

private:
	field grid[PLAYGROUND_WIDTH][PLAYGROUND_HEIGHT];
	SDL_Surface* pDisplay;
};


class queue_key
{
public:
	queue_key();
	~queue_key();
	void push(direction);
	direction get();

private:
	direction ways[20];
	unsigned short int begin, end;
};


class snake
{
protected:
	SDL_Surface *pDisplay;
	TTF_Font *pFont;
	playground *pPlayground;
	SDL_mutex *pMut;
	short int x, y;
	std::queue<koordinate> snake_queue;
	unsigned int punkte;
	unsigned short int default_direction;
	unsigned short int speed;
	Uint32 color;
	unsigned int my_number; // was war das gleich nochmal ?!

	static unsigned int food;

	void generate_food();
	unsigned short int get_speed();
	Uint32 get_color();

public:
	queue_key ways;

	snake(SDL_Surface*, playground*, SDL_mutex*);
	~snake();
	int step();
	static int start(void*);
	void set_speed(unsigned short int);
	void set_color(Uint32);
};

#endif
